/*
 * Decompiled with CFR 0.152.
 */
package examples.webwars;

import examples.webwars.Bonus;
import examples.webwars.WebWars;
import jgame.JGObject;

class Asteroid
extends JGObject {
    private int iconsize;
    private int type;
    private int tmr = 0;
    private double rot = 0.0;
    private double rotspeed;

    public Asteroid(double x, double y, int size, int type) {
        super("Easteroid", true, x, y, 2, null);
        this.iconsize = size;
        this.type = type;
        this.setSpeed((double)this.random(-1, 1, 2) * this.random(0.5, 1.5), (double)this.random(-1, 1, 2) * this.random(0.5, 1.5));
        this.rotspeed = this.random(-0.02, 0.02);
        this.setBBox(32 - size / 2, 32 - size / 2, size, size);
    }

    public void move() {
        if (this.x > (double)pfwidth) {
            this.x = -64.0;
        }
        if (this.y > (double)pfheight) {
            this.y = -64.0;
        }
        if (this.x < -64.0) {
            this.x = pfwidth;
        }
        if (this.y < -64.0) {
            this.y = pfheight;
        }
        this.rot += this.rotspeed;
        ++this.tmr;
    }

    public void hit(JGObject obj) {
        if (!this.isAlive()) {
            return;
        }
        if (obj.colid == 8) {
            obj.remove();
            this.eng.playAudio("explo" + this.random(1, 3, 1));
            ((WebWars)this.eng).genExplo(this.x + 32.0, this.y + 32.0, this.iconsize / 4);
            if ((double)this.iconsize > 30.0) {
                new Asteroid(this.x, this.y, this.iconsize / 2, this.type);
                new Asteroid(this.x, this.y, this.iconsize / 2, this.type);
                if (this.type == 1) {
                    new Asteroid(this.x, this.y, this.iconsize / 2, this.type);
                }
                ((WebWars)this.eng).score += 15;
            } else {
                if (this.random(0.0, 1.0) > 0.6) {
                    new Bonus(this.x, this.y);
                }
                ((WebWars)this.eng).score += 25;
            }
            this.remove();
        }
    }

    public void paint() {
        this.eng.drawImage(this.type == 0 ? "play_blue" : "play_red", this.x, this.y, true, null, 1.0, -this.rot, (double)this.iconsize / 64.0);
    }
}

